<?php

/**
 * UtilityModel
 * utility functions for dates,files etc.
 */
class UtilityModel
{

    public static function testDB($name)
    {
        $database = DatabaseFactory::getFactory()->getConnection();
        $sql = "SHOW DATABASES LIKE :name";
        $query = $database->prepare($sql);
        $parameters = array(':name' => $name);
        $query->execute($parameters);
        $results=$query->fetchAll(PDO::FETCH_ASSOC);
        if(sizeof($results)==0){
            $sql =  file_get_contents(Config::get('URL')."db/hms.sql");
            $query = $database->prepare($sql);
            $query->execute();
        }
        return $results;
       //SHOW DATABASES LIKE 'dbname';
    }

    /**
     * Get a range of years from a given date until now
     * parameters start(string)
     * returns array
     */
     public static function getDatesFromRange($start)
     {
        $range=array();
        $interval = new DateInterval('P1Y');
        $realEnd = new DateTime();
        $period = new DatePeriod(
           new DateTime($start),
           $interval,
           $realEnd
        );
        foreach($period as $date) {
           $range[] = $date->format('Y');
        }
        return $range;
     }

    /**
     * get the root URL of the application
     * parameters none
     * returns string
     */
     public static function getRootURL()
     {
        $domain = $_SERVER['HTTP_HOST'];
        $protocol_array = explode('/',$_SERVER['SERVER_PROTOCOL']);
        $protocol = strtolower($protocol_array[0]);
        $path = str_replace( basename($_SERVER['SCRIPT_FILENAME']), '', $_SERVER['PHP_SELF'] );
        $url = $protocol.'://'.$domain.$path;
        return $url;
     }

    /**
     * get the current working directory
     * parameters none
     * returns string
     */
     public static function getCurrentWorkingDirectory()
     {
        return str_replace('\\', '/', getcwd());
     }

     /**
      * get a list of files and folders for a given directory
      * parameters directory(string)
      * returns array
      */
      public static function getFileList($directory)
      {
         //known types
         $types=array('fldr','html','jpg','gif','doc','png','xml','txt','pdf','htm');
         // arrays to hold return values
         $folders = array();
         $files = array();
         // add trailing slash if missing
         if(substr($directory, -1) != "/") $directory .= "/";
         // open directory for reading
         $items = new DirectoryIterator($directory) or die("getFileList: Failed opening directory $directory for reading");
         foreach($items as $item) {
            // skip hidden files
            if($item->isDot()) continue;
            if($item->getType() == "dir"){
               $folders[] = array(
                  'name' => "{$item}",
                  'path' => "{$directory}{$item}",
                  'type' => "dir",
                  'size' => $item->getSize(),
                  'lastmod' => $item->getMTime()

               );
            }
            else{
               $info=new SplFileInfo("{$item}");
               $files[] = array(
                  'name' => "{$item}",
                  'path' => "{$directory}{$item}",
                  'type' =>'',/* mime_content_type($item->getRealPath()),*/
                  'size' => $item->getSize(),
                  'lastmod' => $item->getMTime(),
                  'ext' => in_array(strtolower($info->getExtension()),$types)? strtolower($info->getExtension()):"unknown"
               );
            }
         }
         sort($folders);
         sort($files);
         return array("folders"=>$folders,"files"=>$files);
      }

     /**
      * add a new folder to a given directory
      * parameters directory(string)
      * returns array
      */
      public static function addFolder($directory)
      {
         if(!file_exists($directory."/new folder")){
            $new=mkdir($directory."/new folder");
         }
         else{
            $nf=1;
            while(file_exists($directory."/new folder".$nf)){
               $nf++;
            }
            $new=mkdir($directory."/new folder".$nf);
         }
         return self::getFileList($directory);
      }

     /**
      * delete file(s) from a given directory
      * parameters directory(string),files(string)
      * returns array
      */
      public static function deleteFile($directory,$files)
      {
         for($fc=0;$fc<count($files);$fc++){
            if(is_dir($files[$fc])){
               self::recursive_remove_directory($files[$fc]);
            }
            else{
               unlink($files[$fc]);
            }
         }
         return self::getFileList($directory);
      }

     /**
      * recursively remove directories from a given directory
      * parameters directory(string),empty(boolean)
      * returns boolean
      */
      private static function recursive_remove_directory($directory, $empty=FALSE)
      {
         // if the path has a slash at the end we remove it here
         if(substr($directory,-1) == '/'){
            $directory = substr($directory,0,-1);
         }
         // if the path is not valid or is not a directory ...
         if(!file_exists($directory) || !is_dir($directory)){
            // ... we return false and exit the function
            return FALSE;
            // ... if the path is not readable
         }elseif(!is_readable($directory)){
            // ... we return false and exit the function
            return FALSE;
            // ... else if the path is readable
         }else{
            // we open the directory
            $handle = opendir($directory);
            // and scan through the items inside
            while (FALSE !== ($item = readdir($handle))){
               // if the filepointer is not the current directory
               // or the parent directory
               if($item != '.' && $item != '..'){
                  // we build the new path to delete
                  $path = $directory.'/'.$item;
                  // if the new path is a directory
                  if(is_dir($path)){
                      // we call this function with the new path
                      self::recursive_remove_directory($path);
                      // if the new path is a file
                  }else{
                      // we remove the file
                      unlink($path);
                  }
               }
            }
            // close the directory
            closedir($handle);
            // if the option to empty is not set to true
            if($empty == FALSE){
               // try to delete the now empty directory
               if(!rmdir($directory)){
                  // return false if not possible
                  return FALSE;
               }
            }
            // return success
            return TRUE;
         }
      }

     /**
      * paste file(s) from one location to another
      * parameters mode(string),from(string),to(string),files(string)
      * returns array
      */
      public static function pasteFile($mode,$from,$to,$files)
      {
         switch($mode){
            case "cut":
            for($fc=0;$fc<count($files);$fc++){
              $rename=rename($from."/".$files[$fc],$to."/".$files[$fc]);
            }

            case "copy":
            for($fc=0;$fc<count($files);$fc++){
               if(is_dir($from."/".$files[$fc])){
                  self::recursive_copy($from."/".$files[$fc],$to."/".$files[$fc]);
               }
               else{
                   copy($from."/".$files[$fc],$to."/".$files[$fc]);
               }
         }


         }
         return self::getFileList($to);
      }

     /**
      * recursively copy directories from a one location to another
      * parameters src(string),dst(string)
      * returns none
      */
      private static function recursive_copy($src,$dst) {
          $dir = opendir($src);
          @mkdir($dst);
          while(false !== ( $file = readdir($dir)) ) {
              if (( $file != '.' ) && ( $file != '..' )) {
                  if ( is_dir($src . '/' . $file) ) {
                      self::recursive_copy($src . '/' . $file,$dst . '/' . $file);
                  }
                  else {
                      copy($src . '/' . $file,$dst . '/' . $file);
                  }
              }
          }
          closedir($dir);
      }

     /**
      * upload file(s) to given directory
      * parameters files(string),directory(string)
      * returns string
      */
      public static function uploadFiles($files,$directory)
      {
         // A list of permitted file extensions
         $allowed = array('png', 'jpg', 'gif','zip','pdf');
         if(isset($files['upl']) && $files['upl']['error'] == 0){
            $extension = pathinfo($files['upl']['name'], PATHINFO_EXTENSION);
            if(!in_array(strtolower($extension), $allowed)){
               return '{"status":"error"}';
               exit;
            }
            if(move_uploaded_file($files['upl']['tmp_name'], $directory.$files['upl']['name'])){
               return '{"status":"success"}';
               exit;
            }
         }
         return '{"status":"error:not set"}';
         exit;
      }

      public static function socket_mail($toArray, $subject, $message)
      {
        // Setup
        $fromName = "Psion HMS";
        $fromEmail = "noreply@psionhms.com";
        $fromMailer = "Socketmail v2.0";
        $smtp = "localhost";
        $smtp_port = 25;
        $charset = "ISO-8859-1";
        // Strip "\r" from the message (if it came from a form input)
        $message = str_replace(chr(13), "", $message);
        // Add a message signature (optional)
        //$message .= "\n\n".str_repeat("_", 60)."\n";
        //$message .= "$fromName <$fromEmail>\n";
        $message = str_replace("\r\n.", "\r\n..", str_replace("\n", "\r\n", stripslashes($message))." \r\n");
        $sendmail=ini_get(sendmail_from);
        ini_set(sendmail_from, $fromEmail);
        $connect = @fsockopen ($smtp, $smtp_port, $errno, $errstr, 5);
        if (!$connect) return false;
        $rcv = fgets($connect, 1024);
        fputs($connect, "HELO {$_SERVER['SERVER_NAME']}\r\n");
        $rcv = fgets($connect, 1024);
        foreach ($toArray as $to) {
           $toBits = explode(" ", $to);
           $toRcpt = trim($toBits[count($toBits) - 1], "<> ");
           fputs($connect, "RSET\r\n");
           $rcv = fgets($connect, 1024);
           fputs($connect, "MAIL FROM:$fromEmail\r\n");
           $rcv = fgets($connect, 1024);
           fputs($connect, "RCPT TO:$toRcpt\r\n");
           $rcv = fgets($connect, 1024);
           fputs($connect, "DATA\r\n");
           $rcv = fgets($connect, 1024);
           fputs($connect, "Subject: $subject\r\n");
           fputs($connect, "From: $fromName <$fromEmail>\r\n");
           fputs($connect, "To: $to\r\n");
           fputs($connect, "X-Sender: <$fromEmail>\r\n");
           fputs($connect, "Return-Path: <$fromEmail>\r\n");
           fputs($connect, "Errors-To: <$fromEmail>\r\n");
           fputs($connect, "Message-Id: <".md5(uniqid(rand())).".".preg_replace("/[^a-z0-9]/i", "", $fromName)."@$smtp>\r\n");
           fputs($connect, "X-Mailer: PHP - $fromMailer\r\n");
           fputs($connect, "X-Priority: 3\r\n");
           fputs($connect, "Date: ".date("r")."\r\n");
           fputs($connect, "Content-type:text/html; charset=$charset\r\n");
           fputs($connect, "\r\n");
           fputs($connect, $message);
           fputs($connect, "\r\n.\r\n");
           $rcv = fgets($connect, 1024);
        }
        fputs ($connect, "QUIT\r\n");
          $rcv = fgets ($connect, 1024);
        fclose($connect);
        ini_set(sendmail_from,$sendmail);
        return true;
      }

}